package mobvista.dmp.datasource.dm

import mobvista.dmp.common.{CommonSparkJob, MobvistaConstant}
import mobvista.dmp.util.MRUtils
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.hadoop.io.compress.GzipCodec

import java.net.URI

/**
 * @package: mobvista.dmp.datasource.dm
 * @author: wangjf
 * @date: 2021/5/6
 * @time: 10:40 上午
 * @email: jinfeng.wang@mobvista.com
 */
class EtlRuidMapping extends CommonSparkJob with Serializable {
  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      printOptions(commandLine)
      return 1
    } else {
      printOptions(commandLine)
    }

    val date = commandLine.getOptionValue("date")
    val output = commandLine.getOptionValue("output")

    val spark = MobvistaConstant.createSparkSession(s"EtlRuidMapping.$date")
    val sc = spark.sparkContext

    try {

      FileSystem.get(new URI(s"s3://mob-emr-test"), sc.hadoopConfiguration).delete(new Path(output), true)

      //  select idfa dev_id,ruid from default.mapping_server_request_log_h where concat(year,month,day) = '${date}' and idfa != 'illegal' and length(idfa) = 36
      val sql =
        s"""
           |select idfv dev_id,ruid from default.mapping_server_request_log_h where concat(year,month,day) = '${date}' and idfv != 'illegal' and length(idfv) = 36
           |""".stripMargin

      val mapping_rdd = spark.sql(sql).dropDuplicates()
        .rdd
        .map(row => {
          MRUtils.JOINER.join(row.getAs[String]("dev_id"), row.getAs[String]("ruid"))
        })

      mapping_rdd.repartition(100)
        .saveAsTextFile(output, classOf[GzipCodec])

    } finally {
      if (spark != null) {
        sc.stop()
        spark.stop()
      }
    }
    0
  }

  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("date", true, "[must] date")
    options.addOption("output", true, "[must] output")
    options
  }
}

object EtlRuidMapping {
  def main(args: Array[String]): Unit = {
    new EtlRuidMapping().run(args)
  }
}