package mobvista.dmp.datasource.dsp

import java.util

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils

import scala.collection.JavaConversions._
import scala.collection.mutable.ArrayBuffer

/**
  * 将 dsp 天数据合并到安装列表全量数据中
  */
class DspInstallList extends CommonInstallList {

  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {

    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    try {
      val device_id = array(0)
      val device_type = array(1)
      val platform = array(2)
      val package_list = array(10).replaceAll("\"", "")
      if (StringUtils.isNotEmpty(package_list) && package_list.startsWith("[")) {
        val jsonArray = GsonUtil.String2JsonArray(package_list)
        val set = GsonUtil.fromJson(jsonArray, classOf[util.HashSet[String]])
        set.foreach(pkg => {
          val installInfo = new InstallInfo(pkg, date)
          if (StringUtils.isNotEmpty(installInfo.getPackage_name())) {
            buffer += Tuple2(s"$device_id${FIELD_SPLIT}$device_type${FIELD_SPLIT}$platform", new InstallInfo(pkg, array(12).substring(0, 10)))
          }
        })
      }
    } catch {
      case e: Exception => {
        e.printStackTrace()
      }
    }

    buffer.toArray
  }
}

object DspInstallList {
  def main(args: Array[String]): Unit = {
    new DspInstallList().run(args)
  }
}