package mobvista.dmp.datasource.facebook

import java.text.SimpleDateFormat

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @author: kehan
  * @date: 2019/06/20
  */
class FaceBookTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    //val date2 = sdf1.format(sdf2.parse(date))
    val sql = Constant.facebook_sql.replace("@dt", date)

    spark.sql(sql)
  }
}

object FaceBookTagDaily {
  def main(args: Array[String]): Unit = {
    new FaceBookTagDaily().run(args)
  }
}