package mobvista.dmp.datasource.iqiyi

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

import scala.collection.mutable.ArrayBuffer

/**
  * @package: mobvista.dmp.datasource.iqiyi
  * @author: wangjf
  * @time: 2019-02-27 18:24:49
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class IQiYiInstallList extends CommonInstallList {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  override def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val package_name = array(3)
    buffer += Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", new InstallInfo(package_name, date))
    buffer.toArray
  }
}

object IQiYiInstallList {
  def main(args: Array[String]): Unit = {
    new IQiYiInstallList().run(args)
  }
}