package mobvista.dmp.datasource.joypac

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

import scala.collection.mutable.ArrayBuffer

/**
  * @package: mobvista.dmp.datasource.joypac
  * @author: wangjf
  * @date: 2019/2/25
  * @time: 下午5:40
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class JoypacInstallList extends CommonInstallList {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {

    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val pkgList = array(3).split(";")
    pkgList.foreach(pkg => {
      buffer += Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", new InstallInfo(pkg, date))
    })
    buffer.toArray
  }
}

object JoypacInstallList {
  def main(args: Array[String]): Unit = {
    new JoypacInstallList().run(args)
  }
}