package mobvista.dmp.datasource.rtdmp

import scala.collection.mutable

/**
 * @package: mobvista.dmp.datasource.rtdmp
 * @author: wangjf
 * @date: 2020/7/13
 * @time: 11:22 上午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
object Constant {

  case class Device(device_id: String)

  case class AudienceInfoPre(devid: String, audience_ids: String, device_type: String)

  case class AudienceInfo(devid: String, audience_data: String, old_audience_data: String)

  case class NewAudienceInfo(devid: String, update_time: String, audience_data: String, device_type: String)

  case class AudienceRegion(audience_info: String, region: mutable.WrappedArray[String])

  case class DmpDeviceRegin(device_id: String, device_type: String, platform: String, region: String, update_date: String, publish_date: String, tag: Int)

  // case class AudienceMerge(devid: String, audience_id: mutable.WrappedArray[Int], update_time: String) extends Serializable

  case class AudienceMerge(devid: String, audience_map: String, update_time: String, device_type: String) extends Serializable

  val read_sql =
    """
      |SELECT CASE WHEN isDeviceMd5(device_id) THEN device_id ELSE md5(device_id) END AS device_id, device_type,region
      | FROM dwh.dmp_device_region WHERE dt = '@dt' AND tag = 1
      |""".stripMargin

  val old_sql =
    """
      |SELECT device_id, device_type, platform, region, update_date, publish_date
      |  FROM dwh.dmp_device_region WHERE dt = '@dt' AND update_date >= '@update_date'
      |""".stripMargin

  val merge_sql =
    s"""SELECT
       |  COALESCE(d.device_id,m.device_id) device_id,
       |  COALESCE(d.device_type,m.device_type) device_type,
       |  COALESCE(d.platform,m.platform) platform,
       |  CASE WHEN d.device_id IS NOT null AND m.device_id IS NOT null THEN parseRegion(CONCAT(m.region, ',', d.region))
       |  WHEN d.device_id IS NOT null THEN d.region ELSE m.region END AS region,
       |  CASE WHEN d.device_id IS NOT null THEN '@before_date' ELSE m.update_date END AS update_date,
       |  CASE WHEN m.device_id IS NOT null THEN check_publish(check_region(m.region,d.region),'@before_date',m.publish_date)
       |  ELSE '@before_date' END AS publish_date,
       |  CASE WHEN m.device_id IS NOT null THEN check_tag(check_region(m.region,d.region),'@before_date',m.publish_date) ELSE 1 END AS tag
       |  FROM
       |    (SELECT device_id, device_type, platform, region, update_date, publish_date
       |      FROM dwh.dmp_device_region WHERE dt = '@dt' AND update_date >= '@update_date'
       |    ) m
       |  FULL OUTER JOIN
       |  device_region_daily d
       |  ON d.device_id = m.device_id
       |""".stripMargin

  val region_sql =
    s"""SELECT device_id, MAX(device_type) device_type, MAX(platform) platform, parseRegion(CONCAT_WS(',',COLLECT_SET(region))) region
       |  FROM
       |    (SELECT device_id, device_type, platform, parseToStr(region) region
       |      FROM dwh.etl_dsp_request_daily WHERE `date` = '@date' AND region != '[]' AND check_deviceId(device_id)
       |      GROUP BY device_id, device_type, platform, region
       |      UNION
       |      SELECT device_id, device_type, platform, parseToStr(region) region
       |      FROM dwh.etl_dsp_request_unmatch WHERE `dt` = '@dt' AND datetime >= '@date 00:00:00' AND region != '[]' AND check_deviceId(device_id)
       |      GROUP BY device_id, device_type, platform, region
       |      UNION
       |      SELECT device_id, device_type, platform, region
       |      FROM dwh.etl_adn_request_sdk_daily WHERE `dt` = '@dt' AND region != '' AND check_deviceId(device_id)
       |      GROUP BY device_id, device_type, platform, region
       |      UNION
       |      SELECT device_id, device_type, platform, region
       |      FROM dwh.etl_adn_request_sdk_unmatch WHERE `dt` = '@dt' AND update_date = '@date' AND region != '' AND check_deviceId(device_id)
       |      GROUP BY device_id, device_type, platform, region
       |   ) t
       |  GROUP BY device_id
       |""".stripMargin

  //  AND check_package(package_name)
  val device_sql =
    """
      |SELECT device_id, device_type, platform, package_name
      |   FROM dwh.@table WHERE dt = '@dt' AND business = '@business' @check_update_date @check_package @check_hr
      |   GROUP BY device_id, device_type, platform, package_name
      |""".stripMargin

  val tencent_device_sql =
    """
      |SELECT device_id, device_type, platform, package_name
      |   FROM dwh.@table WHERE dt = '@dt' @check_package @check_hr
      |   GROUP BY device_id, device_type, platform, package_name
      |""".stripMargin

  val package_sql =
    """
      |SELECT device_type, platform, package_name
      |   FROM dwh.dm_install_list_v2 WHERE dt = '@dt' AND business = '@business' AND update_date = '@update_date' AND package_name IN (@filter_package)
      |   GROUP BY device_type, platform, package_name
      |""".stripMargin

  val device_info_sql =
    """
      |SELECT device_id, device_type, processToRegion(ext_data) region
      |  FROM dwh.dmp_install_list WHERE dt = '@dt' AND business = 'day'
      |""".stripMargin

  val foractivationIdSet: mutable.Set[Integer] = mutable.Set(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 108,
    109, 110, 111, 112, 122, 123, 180, 181, 182, 185, 186, 196, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
    217, 237, 238, 333, 334, 335, 336, 337, 338, 339, 340, 343, 344, 349, 350, 352, 353, 354, 355, 356, 357, 358,
    359, 360, 367, 369, 370, 374, 375, 376, 377, 380, 381, 382, 383, 369, 384, 385, 386, 387, 388, 389, 390, 391,
    392, 393, 394, 395, 396, 405, 406, 407)

  //  val dspIdSet: mutable.Set[Integer] = mutable.Set(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 108, 109, 110, 111, 112, 122, 123, 180, 181, 182)

  val adxIdSet: mutable.Set[Integer] = mutable.Set(115, 187, 190, 218, 281, 364, 368)

}
