package mobvista.dmp.datasource.taobao

import java.net.URI

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.sql.SparkSession


class AlipayOtherDataToDmp extends CommonSparkJob with Serializable  {
  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("dt_today", true, "[must] dt_today")
    options.addOption("dt_oneday_ago", true, "[must] dt_oneday_ago")
    options.addOption("output01",true, "[must] output01")
    options.addOption("output02",true, "[must] output02")
    options.addOption("hour",true, "[must] hour")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val dt_today = commandLine.getOptionValue("dt_today")
    val dt_oneday_ago = commandLine.getOptionValue("dt_oneday_ago")
    val output01 = commandLine.getOptionValue("output01")
    val output02 = commandLine.getOptionValue("output02")
    val hour = commandLine.getOptionValue("hour")

    val spark = SparkSession.builder()
      .appName("AlipayOtherDataToDmp")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()



    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output01), true)
    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output02), true)

    val sc = spark.sparkContext
    try {

      val country="CN"
      val sql1 =
        s"""
           |select distinct t1.device_id from
           |(select device_id from dwh.etl_alipay_activation_daily
           |where dt='${dt_today}'  and  hh='${hour}'  and device_type='imeimd5' and business='alipay_activation'
           |and package_name in ('com.alipay.foractivation_L00016')) t1
           |inner join
           |(select device_id from dwh.dm_install_list_v2
           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
           |and package_name in ('com.eg.android.AlipayGphone_oppo')) t2
           |on t1.device_id=t2.device_id
        """.stripMargin

      spark.sql(sql1).rdd.map(_.mkString).map(row => {
        row + "\t" + "imeimd5" + "\t" + "android" + "\t" + "com.alipay.foractivation_l00016_alipayoppo" + "\t" + country
      }).coalesce(500).saveAsTextFile(output01)

      val sql2 =
        s"""
           |select distinct t1.device_id from
           |(select device_id from dwh.etl_alipay_activation_daily
           |where dt='${dt_today}'  and  hh='${hour}'  and device_type='imeimd5' and business='alipay_activation'
           |and package_name in ('com.alipay.foractivation_L00016')) t1
           |inner join
           |(select device_id from dwh.dm_install_list_v2
           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
           |and package_name in ('com.eg.android.AlipayGphone_bes')) t2
           |on t1.device_id=t2.device_id
        """.stripMargin

      spark.sql(sql2).rdd.map(_.mkString).map(row => {
        row + "\t" + "imeimd5" + "\t" + "android" + "\t" + "com.alipay.foractivation_l00016_alipaybes" + "\t" + country
      }).coalesce(500).saveAsTextFile(output02)


    } finally {
      spark.stop()
    }
    0
  }
}


object AlipayOtherDataToDmp {
  def main(args: Array[String]): Unit = {
   new AlipayOtherDataToDmp().run(args)
  }
}
