package mobvista.dmp.function

import com.googlecode.aviator.runtime.`type`.AviatorFunction
import com.googlecode.aviator.{AviatorEvaluator, Expression}

object FunctionManager extends Serializable {
  var expressionMap = Map[String,Expression]()

  val EXP_SPLIT_TEXT_INPUT = "split_text_input_data(line)"
  val EXP_SPLIT_TEXT_INPUT_INDICES = "split_text_input_data(line, indices)"
  val EXP_SPLIT_RCFILE_INPUT = "split_rcfile_input_data(line, indices)"
  val EXP_SPLIT_ORC_INPUT = "split_orc_input_data(line)"
  val EXP_SPLIT_ORC_INPUT_INDICES = "split_orc_input_data(line, indices)"
  val EXP_BUILD_ADDRESSVO_INPUT_INDICES = "build_addressvo(line, indices)"


  AviatorEvaluator.addFunction(new SplitTextInputData)
  AviatorEvaluator.addFunction(new SplitRCFileInputData)
  AviatorEvaluator.addFunction(new SplitORCInputData)
  AviatorEvaluator.addFunction(new BuildAddressVO)


  setExpression(EXP_SPLIT_TEXT_INPUT)
  setExpression(EXP_SPLIT_TEXT_INPUT_INDICES)
  setExpression(EXP_SPLIT_RCFILE_INPUT)
  setExpression(EXP_SPLIT_ORC_INPUT)
  setExpression(EXP_SPLIT_ORC_INPUT_INDICES)
  setExpression(EXP_BUILD_ADDRESSVO_INPUT_INDICES)


  def setExpression(express :String) {
    val expression = expressionMap.getOrElse(express, AviatorEvaluator.compile(express))
    if(!expressionMap.contains(express)){
      expressionMap += (express -> expression)
    }
  }

  def getExpression(express :String) :Expression ={
    val expression = expressionMap.getOrElse(express, AviatorEvaluator.compile(express))
    if(!expressionMap.contains(express)){
      expressionMap += (express -> expression)
    }
    expression
  }

  def addAviatorEvaluatorFunction(function :AviatorFunction){
    AviatorEvaluator.addFunction(function)
  }
}
