package mobvista.dmp.function

import java.util

import com.googlecode.aviator.runtime.`type`.{AviatorJavaType, AviatorObject}
import com.googlecode.aviator.runtime.function.FunctionUtils

import scala.collection.mutable.ArrayBuffer

class SplitTextInputData extends CommonFunction {
  override def getName = "split_text_input_data"

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject, arg2 : AviatorObject) = {
    val line = FunctionUtils.getStringValue(arg1, env)
    val indices = FunctionUtils.getStringValue(arg2, env)
    val lineSplits = splitFun(line)
    val buffer = new ArrayBuffer[String]
    splitFun(indices, ",")
      .foreach(index => {
        buffer += lineSplits(index.toInt)
      })
    env.put("array", buffer.toArray)
    new AviatorJavaType("array")
  }

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject) = {
    val line = FunctionUtils.getStringValue(arg1, env)
    env.put("array", splitFun(line))
    new AviatorJavaType("array")
  }
}
