package mobvista.dmp.main

import java.io._
import java.util
import scala.collection.JavaConversions._

object MergeBundlePkg {
  def main(args: Array[String]): Unit = {
    if (args.length < 3) {
      println("Usage : <old_file> <match_file> <result_file>")
      System.exit(1)
    }
    val oldFile = args(0)
    val matchFile = args(1)
    val resultFile = args(2)

    val oldSet = parseFile(oldFile)
    val matchSet = parseFile(matchFile)
    oldSet.addAll(matchSet)

    writeFile(oldSet, resultFile)
  }

  def writeFile(set : util.HashSet[String], file : String): Unit = {
    var writer : BufferedWriter = null
    try {
      val out = new FileOutputStream(file)
      writer = new BufferedWriter(new OutputStreamWriter(out))
      set.foreach(line => {
        writer.write(line)
        writer.newLine()
      })
    } finally {
      if (writer != null) {
        writer.flush()
        writer.close()
      }
    }
  }

  def parseFile(path : String): util.HashSet[String] = {
    val set = new util.HashSet[String]()
    var reader : BufferedReader = null
    try {
      val in = new FileInputStream(path)
      reader = new BufferedReader(new InputStreamReader(in))
      var line = reader.readLine()
      while (line != null) {
        set.add(line)
        line = reader.readLine()
      }
      return set
    } finally {
      if (reader != null) {
        reader.close()
      }
    }
  }
}

