#!/usr/bin/env bash

source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_ADN_INSTALL_PATH="${ADN_CLICK_PATH}/$year/$month/$day"
OUTPUT_ADN_INSTALL_DAILY="${ETL_ADN_CLICK_DAILY}/$year/$month/$day"

check_await $INPUT_ADN_INSTALL_PATH/virginia/23/_SUCCESS

hadoop fs -rm -r "$OUTPUT_ADN_INSTALL_DAILY/"

spark-submit --class mobvista.dmp.datasource.adn.AdnClickDaily \
  --name "AdnClickDaily.${LOG_TIME}" \
  --conf spark.sql.shuffle.partitions=1000 \
  --conf spark.default.parallelism=1000 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --master yarn --deploy-mode cluster \
  --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 50 \
  ../.././DMP.jar \
  -datetime ${LOG_TIME} -output ${OUTPUT_ADN_INSTALL_DAILY} -coalesce 200

if [[ $? -ne 0 ]]; then
  exit 255
fi

: '
hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnClickDailyMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_INSTALL_PATH" "$OUTPUT_ADN_INSTALL_DAILY" || exit 1
'
