#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_request_daily.sh
# @author: walt
# @date  : 16-12-01
# @desc  : 从ods_adn_trackingnew_request中抽取appid并匹配出package_name，保存到etl_adn_sdk_request_daily
# # # # # # # # # # # # # # # # # # # # # #


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
old_path=$(date -d "$ScheduleTime 2 days ago" "+%Y/%m/%d")
date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")
task_date=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")

INPUT_ADN_SDK_PKG_DAILY="$ETL_ADN_ORG_REQ_HOURS/${date_path}"
INPUT_MAPPING_PATH="$APP_ID_MAPPING/$date_path"
TMP_OUTPUT_PATH="${TMP_AND_REQUEST_DAILY_PATH}/$date_path"
OUTPUT="$ETL_ADN_SDK_REQUEST_DAILY/$date_path"


check_await "$INPUT_ADN_SDK_PKG_DAILY/virginia/23/_SUCCESS"
check_await "$INPUT_MAPPING_PATH/_SUCCESS"

hadoop fs -rm -r "$TMP_OUTPUT_PATH"

## REDUCE_NUM=$(calculate_reduce_num "${INPUT_ADN_SDK_PKG_DAILY};${INPUT_MAPPING_PATH}")

export HADOOP_CLIENT_OPTS="-Xmx2496m $HADOOP_CLIENT_OPTS"
hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnSdkRequestPkgDailyMR \
    -Dtask.date="${task_date}" \
    -Dmapreduce.map.memory.mb=4072 \
    -Dmapreduce.map.java.opts=-Xmx3458m \
    -Dmapreduce.reduce.memory.mb=4072 \
    -Dmapreduce.reduce.java.opts=-Xmx3458m \
    -Dmapreduce.job.reduces=300 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_SDK_PKG_DAILY" "$INPUT_MAPPING_PATH" "$TMP_OUTPUT_PATH" "${DIM_MANUAL_MAPPING}"

if [[ $? -ne 0 ]]; then
    exit 255
fi

# 为bundleId 匹配 packageName
matchBundlePackage "$date_path" "$old_path" "2" "4" "$TMP_OUTPUT_PATH" "$OUTPUT" "adn_request" "../../${JAR}"

mount_partition "etl_adn_sdk_request_daily" "\`date\`='$LOG_TIME'" "$OUTPUT" || exit 1

echo "[Etl Adn Sdk request Daily End!]"