#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_one_day_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")




#检查表分区是否已经存在,不存在等待十个小时退出脚本
partition_info="dt='$dt_dash_today'"
check_await_hive_partition "uparpu_main.uparpu_device_active" $partition_info 36000


DMP_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/TO"
mount_partition "dm_install_list_v2" "dt='${dt_today}', business='TO'" "${DMP_INSTALL_LIST_OUTPUT_PATH}"


HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar update_date ${dt_dash_today}  -hivevar  dt_one_day_ago ${dt_one_day_ago}  -f Topon.sql