set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;
set hive.jobname.length=100;

insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='append',business)
select t2.device_id,t2.filename business from
(select device_id,substr(split(INPUT__FILE__NAME,"/")[11],6) as filename from dwh.gdt_data where day='${dt_yesterday}' and category='all' and business='total') t1
right join
(select device_id,substr(split(INPUT__FILE__NAME,"/")[11],6) as filename from dwh.gdt_data where day='${dt_today}'  and category='all'  and business='total') t2
on t1.device_id=t2.device_id and t1.filename=t2.filename
where t1.device_id is null and t1.filename is null;



insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='delete',business)
select t1.device_id,t1.filename business from
(select device_id,substr(split(INPUT__FILE__NAME,"/")[11],6) as filename from dwh.gdt_data where day='${dt_yesterday}'  and category='all'  and business='total') t1
left join
(select device_id,substr(split(INPUT__FILE__NAME,"/")[11],6) as filename from dwh.gdt_data where day='${dt_today}'  and category='all'  and business='total') t2
on t1.device_id=t2.device_id and t1.filename=t2.filename
where t2.device_id is null and t2.filename is null;

