#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"


#H_18_IMEI
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imei'" "${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH}"
#H_18_HASH_IMEI
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imeimd5'" "${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH}"

#H_18_IMEI append
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei_append"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imei_append'" "${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH}"
#H_18_HASH_IMEI append
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5_append"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imeimd5_append'" "${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH}"

#H_18_IMEI delete
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei_delete"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imei_delete'" "${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH}"
#H_18_HASH_IMEI delete
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5_delete"
mount_partition "gdt_data" "day='${dt_today}', category='AlipayGphone_oppo_package', business='imeimd5_delete'" "${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH}"

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -hivevar  dt_oneday_ago ${dt_oneday_ago}  -f ali_extract_guangdiantong_data_h_18_from_dsp_req.sql

if [ $? -ne 0 ];then
  exit 255
fi