#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_one_day_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_one_day_dash_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")


HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar update_date ${dt_dash_today}  -hivevar dt_one_day_ago ${dt_one_day_ago}  -hivevar dt_one_day_dash_ago ${dt_one_day_dash_ago}  -f ali_insert_other_data_to_dmp_v2.sql

if [ $? -ne 0 ];then
  exit 255
fi


#下游入arospike会以此_SUCCESS文件为标志启动计算
OUTPUT_PATH="${ETL_ALI_USERINFO_ACTIVATION_PATH}/${dt_slash_today}"
ALI_IOS_OUTPUT="${ETL_ALI_IOS_USERINFO_ACTIVATION_PATH}/${dt_slash_today}"
ALI_OAID_OUTPUT="${ETL_ALI_OAID_USERINFO_ACTIVATION_PATH}/${dt_slash_today}"
DMP_ALI_ACTIVATION_USER_INFO_OUTPUT_PATH="${ODS_DMP_USER_INFO}/${dt_slash_today}/ali_activation"
DMP_ALI_ACQUISTION_USER_INFO_OUTPUT_PATH="${ODS_DMP_USER_INFO}/${dt_slash_today}/ali_acquisition"
DMP_ALI_ACQUISTION_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/ali_acquisition"
DMP_ALI_ACTIVATION_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/ali_activation"

#下游入arospike会以此_SUCCESS文件为标志启动计算
hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS

hadoop fs -touchz ${ALI_IOS_OUTPUT}/_SUCCESS
hadoop fs -touchz ${ALI_OAID_OUTPUT}/_SUCCESS
hadoop fs -touchz ${DMP_ALI_ACTIVATION_USER_INFO_OUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${DMP_ALI_ACQUISTION_USER_INFO_OUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${DMP_ALI_ACQUISTION_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${DMP_ALI_ACTIVATION_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS

echo "good job~~"
