#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")

## 等待支付宝拉活设备入库
ALIPAY_LAHUO_OUTPUT_PATH="${ALIPAY_ACTIVATION_DAILY_PATH}/${dt_slash_today}/04"
check_await "${ALIPAY_LAHUO_OUTPUT_PATH}/_SUCCESS"

## 等待支付宝拉新设备入库
ALIPAY_LAXIN_OUTPUT_PATH="${ALIPAY_ACQUISITION_DAILY_PATH}/${dt_slash_today}/04"
check_await "${ALIPAY_LAXIN_OUTPUT_PATH}/_SUCCESS"

#all
LAXIN_0_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_0"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='laxin_0'" "${LAXIN_0_SYS_TO3S_PATH}"

LAXIN_1_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_1"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='laxin_1'" "${LAXIN_1_SYS_TO3S_PATH}"

LAXIN_2_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_2"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='laxin_2'" "${LAXIN_2_SYS_TO3S_PATH}"

LAHUO_0_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_0"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_0'" "${LAHUO_0_SYS_TO3S_PATH}"

LAHUO_1_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_1"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_1'" "${LAHUO_1_SYS_TO3S_PATH}"

LAHUO_2_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_2"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_2'" "${LAHUO_2_SYS_TO3S_PATH}"

LAHUO_3_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_3"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_3'" "${LAHUO_3_SYS_TO3S_PATH}"

LAHUO_4_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_4"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_4'" "${LAHUO_4_SYS_TO3S_PATH}"

LAHUO_5_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_5"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin', business='lahuo_5'" "${LAHUO_5_SYS_TO3S_PATH}"


HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -f   alipay_lahuo_laxin_all_data_to_dmp.sql

if [ $? -ne 0 ];then
  exit 255
fi

echo "good job~~"


