set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_lahuo',business='total')
      select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.foractivation';


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_not_lahuo',business='total')
      select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.notforactivation';


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_lahuo_append',business='total')
      select t1.device_id from
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.foractivation') t1
      left join
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_yesterday}' and business="iqiyi_activation" and package_name='com.iqiyi.foractivation') t2
      on t1.device_id=t2.device_id
      where t2.device_id is null;

insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_not_lahuo_append',business='total')
      select t1.device_id from
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.notforactivation') t1
      left join
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_yesterday}' and business="iqiyi_activation" and package_name='com.iqiyi.notforactivation') t2
      on t1.device_id=t2.device_id
      where t2.device_id is null;


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_lahuo_delete',business='total')
      select t2.device_id from
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.foractivation') t1
      right join
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_yesterday}' and business="iqiyi_activation" and package_name='com.iqiyi.foractivation') t2
      on t1.device_id=t2.device_id
      where t1.device_id is null;


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='iqiyi_not_lahuo_delete',business='total')
      select t2.device_id from
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_today}' and business="iqiyi_activation" and package_name='com.iqiyi.notforactivation') t1
      right join
      (select device_id
             from dwh.dm_install_list_v2
      where dt='${dt_yesterday}' and business="iqiyi_activation" and package_name='com.iqiyi.notforactivation') t2
      on t1.device_id=t2.device_id
      where t1.device_id is null;

