#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")



: '
401：com.kuaishou.rta_imei
402：com.kuaishou.rta_oaid
403：com.kuaishoujisu.rta_imei
404：com.kuaishoujisu.rta_oaid
'

INPUT_PATH01="s3://mob-emr-test/rt-dsp/dmp/kuaishou_offline_rta_audience_imei/${dt_slash_today}"
INPUT_PATH02="s3://mob-emr-test/rt-dsp/dmp/kuaishou_offline_rta_audience_oaid/${dt_slash_today}"
INPUT_PATH03="s3://mob-emr-test/rt-dsp/dmp/kuaishou_lite_offline_rta_audience_imei/${dt_slash_today}"
INPUT_PATH04="s3://mob-emr-test/rt-dsp/dmp/kuaishou_lite_offline_rta_audience_oaid/${dt_slash_today}"

check_await "${INPUT_PATH01}/_SUCCESS"
check_await "${INPUT_PATH02}/_SUCCESS"
check_await "${INPUT_PATH03}/_SUCCESS"
check_await "${INPUT_PATH04}/_SUCCESS"

mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='kuaishou_rta_imei'" "${INPUT_PATH01}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='kuaishou_rta_oaid'" "${INPUT_PATH02}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='kuaishoujisu_rta_imei'" "${INPUT_PATH03}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='kuaishoujisu_rta_oaid'" "${INPUT_PATH04}"

DMP_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/kuaishou_foractivation"
mount_partition "dm_install_list_v2" "dt='${dt_today}', business='kuaishou_foractivation'" "${DMP_INSTALL_LIST_OUTPUT_PATH}"

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar update_date ${dt_dash_today}  -f kuaishou_foractivation.sql