#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : 刘凯
# @date : 2018-01-16s
# @desc : mearge app_info adr数据
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

OUTPUT_PATH="${APP_INFO_ADR_PATH}/$date_path"
INPUT_PATH="${DIM_APP_INFO_ADR}/$date_path/*/*.orc"

check_await "${APP_TAG_PATH}/$date_path/_SUCCESS"

hadoop fs -rmr ${OUTPUT_PATH}

spark-submit --class mobvista.dmp.datasource.app_info_tag.Merge_app_info_adr \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster --name merge_app_info_adr \
 --conf spark.app.loadTime=${LOG_TIME} --conf spark.app.output_path=${OUTPUT_PATH} --conf spark.app.input_path=${INPUT_PATH} \
 --executor-memory 6g --driver-memory 4g --executor-cores 2 --num-executors 30 \
 ../${JAR}
 
if [[ $? -ne 0 ]];then
  exit 255
fi

# 因补充标签数据，故 touchz _OK
hadoop fs -touchz ${OUTPUT_PATH}/_OK