#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : merge_app_tag.sh
# @author: houying
# @date  : 16-11-7
# @desc  : 合并ios和adr平台的package标签信息，对外提供一个一致的视图
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_IOS="$APP_INFO_IOS_PATH/$year/$month/$day"
INPUT_ADR="$APP_INFO_ADR_PATH/$year/$month/$day"
OUTPUT="$APP_TAG_PATH/$year/$month/$day"

hadoop fs -rm "$OUTPUT/*"

hadoop jar ../${JAR} mobvista.dmp.datasource.apptag.mapreduce.MergeAppInfoMRv2 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADR" "$INPUT_IOS" "$OUTPUT" "$DIM_CATEGORY_PATH" || exit 1

mount_partition dim_app_tag "year='$year',month='$month', day='$day'" ${OUTPUT} || exit 1

echo "[Merge App Tag End]"