#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : install_list_other.sh
# @author: houying
# @date  : 17-3-14
# # # # # # # # # # # # # # # # # # # # # # 

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH=""

if hadoop fs -test -e "$(build_path_by_date "$TMP_EGGPLANTS_OUTPUT_PATH" "$LOG_TIME")"
then
    INPUT_PATH="$(append "$INPUT_PATH" "$(build_path_by_date "$TMP_EGGPLANTS_OUTPUT_PATH" "$LOG_TIME")" ",")"
fi

if hadoop fs -test -e "$(build_path_by_date "$ZAROLA_INSTALL_OUTPUT" "$LOG_TIME")"
then
    INPUT_PATH="$(append "$INPUT_PATH" "$(build_path_by_date "$ZAROLA_INSTALL_OUTPUT" "$LOG_TIME")" ",")"
fi

if [[ -z "$INPUT_PATH" ]]
then
    echo "两天前的数据还没准备好，干啥吃的你们！"
    exit 1
fi

LOG_TIME=$(date +%Y%m%d -d "-3 day $ScheduleTime")
inyear=${LOG_TIME:0:4}
inmonth=${LOG_TIME:4:2}
inday=${LOG_TIME:6:2}

INPUT="$DM_INSTALL_LIST/$inyear/$inmonth/$inday/other"
OUTPUT_PATH="$DM_INSTALL_LIST/$year/$month/$day/other"
hadoop fs -rm -r "$OUTPUT_PATH"

hadoop jar ../${JAR} mobvista.dmp.datasource.dm.mapreduce.DmInstallListOtherMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -Dmapred.reduce.tasks=20 \
    -Dtask.date=${year}-${month}-${day} \
    -Dmapreduce.input.fileinputformat.inputdir=${INPUT_PATH},${INPUT} \
    -Dmapreduce.output.fileoutputformat.outputdir=${OUTPUT_PATH} || exit 1

mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='other'" "$OUTPUT_PATH"