# !/bin/sh
source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

expire_date=$(date -d "$ScheduleTime 91 days ago" +"%Y%m%d")
expire_date_path=$(date -d "$ScheduleTime 91 days ago" +"%Y/%m/%d")
business='3s'

input_path="${EVNET_3S_PATH}/${date_path}/singapore/*/*"

## CAMPAIGN_LIST_DATE=$(get_recently_date "${ETL_CAMPAIN_LIST_PATH}" "${date}" "")
OUTPUT_PATH="${ODS_DMP_EVENT_ORG}/${date_path}/${business}"
EXPIRE_PATH="${ODS_DMP_EVENT_ORG}/${expire_date_path}/${business}"

# dwh.ods_dmp_event_org
hadoop fs -rmr ${OUTPUT_PATH}

spark-submit --class mobvista.dmp.datasource.event_tag.Dmp3sEventTag \
  --conf spark.sql.shuffle.partitions=1000 \
  --conf spark.default.parallelism=1000 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --conf spark.sql.adaptive.enabled=true \
  --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=268435456 \
  --name dmp_3s_event_tag \
  --conf spark.akka.frameSize=100 \
  --files ${HIVE_SITE_PATH} \
  --master yarn --deploy-mode cluster --driver-memory 4g --executor-cores 2 --executor-memory 4G --num-executors 20 \
  ../${JAR} \
  -today ${date} -input ${input_path} -output ${OUTPUT_PATH} -coalesce 100

if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "ods_dmp_event_org" "dt='${date}',business='3s'" "$OUTPUT_PATH"

# 删除过期的分区及删除对应路径
unmount_partition "ods_dmp_event_org" "dt='${expire_date}',business='3s'" "${EXPIRE_PATH}"

hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS
