#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : dsp_req_pkg_total.sh
# @author: houying
# @date  : 16-11-9
# # # # # # # # # # # # # # # # # # # # # #


source ../dmp_env.sh


LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_DSP_REQ_PKG_DAILY_PATH="$ETL_DSP_REQ_DAILY/$year/$month/$day"
INPUT_DSP_REQ_PKG_TOTAL_PATH="$DM_INSTALL_LIST/$old_year/$old_month/$old_day/dsp_req"
OUTPUT="$DM_INSTALL_LIST/$year/$month/$day/dsp_req"

check_await "${INPUT_DSP_REQ_PKG_TOTAL_PATH}/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num "${INPUT_DSP_REQ_PKG_TOTAL_PATH};${INPUT_DSP_REQ_PKG_DAILY_PATH}")

haodop fs -rm -r $OUTPUT

hadoop jar ../${JAR} mobvista.dmp.datasource.dsp.mapreduce.DspReqPkgTotalMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dtask.date=${year}-${month}-${day} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_DSP_REQ_PKG_DAILY_PATH" "$INPUT_DSP_REQ_PKG_TOTAL_PATH" "$OUTPUT" || exit 1

mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='dsp_req'" "$OUTPUT" || exit 1

echo "[Dsp Req Pkg Total End!]"