#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :ga_device_daily.sh
# @author  :ying.hou
# @revision:2016-09-23 17:58:26
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH_DEVICE="${GA_PREPARE_PATH}/${year}/${month}/${day}/device-metrics"
OUTPUT_PATH="${GA_DAILY_PATH}/${year}/${month}/${day}"

echo "INPUT_PATH_DEVICE=$INPUT_PATH_DEVICE"
echo "OUTPUT_PATH=$OUTPUT_PATH"

check_await "$INPUT_PATH_DEVICE/_SUCCESS"

hadoop fs -rm -r ${OUTPUT_PATH}
hadoop jar ../${JAR} mobvista.dmp.datasource.ga.mapreduce.GaDeviceDailyMR \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  -Dtask.date=${LOG_TIME} \
  "${INPUT_PATH_DEVICE}" "${OUTPUT_PATH}" || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi

mount_partition "ods_ga_device_daily" "\`date\`='${LOG_TIME}'" "$OUTPUT_PATH"

echo "[ga device daily End!]"
