#!/bin/bash
source ./common/tools.sh

today=${ScheduleTime:-$1}

echo "ScheduleTime=$ScheduleTime"
echo "toady=$today"

part_pre1_path=$(date +%Y%m%d -d "-1 day $today")
part_pre2_path=$(date +%Y%m%d -d "-2 day $today")
part_pre10_path=$(date +%Y%m%d -d "-10 day $today")
date_str_undline=$(date +%Y_%m_%d -d "-1 day $today")

HIVE_CMD=$(hive_func)

hadoop fs -test -e s3://mob-emr-test/dataplatform/emr/player/${part_pre1_path}
if [ $? -ne 0 ]; then
  hadoop fs -mkdir -p s3://mob-emr-test/dataplatform/emr/player/${part_pre1_path}
fi

$HIVE_CMD -v -hivevar date_str_undline=$date_str_undline -hivevar part_pre1_path=$part_pre1_path -hivevar part_pre2_path=$part_pre2_path -f player.sql

hadoop fs -test -e s3://mob-emr-test/dataplatform/emr/player/${part_pre10_path}
if [ $? -eq 0 ]; then
  hadoop fs -rmr s3://mob-emr-test/dataplatform/emr/player/${part_pre10_path}
fi
