#! /bin/bash


# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 16:12
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

TWO_DAYS_AGO=$(date +%Y%m%d -d "-2 day $ScheduleTime")

INPUT_PATH_GA=$(get_recently_dir "$GA_TOTAL_PATH" "$TWO_DAYS_AGO" "")
OUTPUT_PATH="${GENDER_GET_GA_PATH}/${year}/${month}/${day}/"

hadoop fs -rm -r ${OUTPUT_PATH}
REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH_GA})
hadoop jar ../${JAR} mobvista.dmp.datasource.gender.GetGaGenderMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INPUT_PATH_GA}" "${OUTPUT_PATH}" || exit 1

 if [ $? -ne 0 ]; then
    exit 255
fi
