#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-08-28 18:06:59
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")

OUTPUT_PATH="${IQiYi_DAILY_PATH}/$date_path"

spark-submit --class mobvista.dmp.datasource.iqiyi.IQiYiDaily \
     --name "IQiYiDaily.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --files /data/hadoop-config/command-home/hdp-spark-2.3.1-offline/conf/hive-site.xml \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 3  --num-executors 10 \
     ../${JAR} -date ${LOG_TIME} -partNum 10 -output ${OUTPUT_PATH} -cluster 'cluster_1st'

if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "etl_iqiyi_daily" "dt='${LOG_TIME}'" "$OUTPUT_PATH"