#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2020-05-14 17:35:10
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

fors=$1
concurrent=$2
LOG_TIME=$(date -d "$ScheduleTime" +"%Y-%m-%d")

if [[ ! -d "/home/hadoop/wangjf" ]]; then
  mkdir /home/hadoop/wangjf

  cd /home/hadoop/wangjf/

  hdfs dfs -get s3://mob-emr-test/wangjf/data/pem/dataplatform_cn.pem .

  chmod 600 dataplatform_cn.pem
fi

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.iqiyi.IQiYiMain"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]]; then
  exit 255
fi

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "/root/workspace/exec_iqiyi.sh ${fors} ${concurrent} ${LOG_TIME} >/root/workspace/exec_iqiyi.log"

if [[ $? -ne 0 ]]; then
  exit 255
fi

pid=$(ps aux | grep "/root/workspace/exec_iqiyi.sh" | awk '{print $2}' | sort -n | head -n 1)

echo "ssh command is running, pid:${pid}"

sleep 10 && kill ${pid} && echo "ssh command is complete"

exit 0
