#!/bin/sh

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

INTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_user_info/${date_path}"

check_await ${INTPUT}/_SUCCESS

sleep 60

DICT_PATH="s3://mob-emr-test/dataplatform/data/joypac/dict_package/${date_path}"
OUTPUT_PATH="s3://mob-emr-test/dataplatform/data/joypac/user_info/${date_path}"

spark-submit --class mobvista.dmp.datasource.joypac.JoypacUserFeatureJob \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=1000 \
 --conf spark.kryoserializer.buffer.max=512m \
 --conf spark.kryoserializer.buffer=64m \
 --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
 --files ${HIVE_SITE_PATH} \
 --jars ${SPARK_HOME}/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
 --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 100 \
 ../${JAR} -date ${LOG_TIME} -output ${OUTPUT_PATH} -dict_output ${DICT_PATH} -coalesce 200

if [[ $? -ne 0 ]];then
  exit 255
fi