#!/bin/sh

source ../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
echo ${today}
echo ${yesterday}

INPUT_PATH="${ETL_DSP_DEALERID_RETARGET_DAILY}/${today}"
OLD_INPUT_PATH="${DM_INSTALL_LIST}/${yesterday}/mopub_dealerid"
OUTPUT_PATH="${DM_INSTALL_LIST}/${today}/mopub_dealerid"

check_await "$INPUT_PATH/_SUCCESS"
check_await "$OLD_INPUT_PATH/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH/"

spark-submit --class mobvista.dmp.datasource.postback_3s.PostBackInstallList \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=100 \
 --master yarn --deploy-mode cluster --name PostBackInstallList --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 30 \
 ../${JAR} -input ${INPUT_PATH} -oldInput ${OLD_INPUT_PATH} -output ${OUTPUT_PATH} -date ${dt} -parallelism 160 -coalesce 160


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_install_list" "year='${dt_today:0:4}', month='${dt_today:4:2}', day='${dt_today:6:2}', business='mopub_dealerid'" "$OUTPUT_PATH"