use dev;
drop table dwh.dm_active_tag;

create external table dwh.dm_active_tag (
  device_id string comment 'device id',
  device_type string comment 'device_type',
  platform string comment 'platform',
  country_code string comment '国家编码',
  region string comment 'region 编码',
  tags string comment 'JsonArray:标签ID、cnt、count'
)partitioned by (
  dt string comment '分区字段，yyyyMMdd',
  part string comment 'week,month'
)stored as orc
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_active_tag';

use dwh;
drop table dwh.dmp_device_tag_statistics;

create external table dwh.dmp_device_tag_statistics (
  device_id string comment 'device id',
  tags string comment 'tags,JSON'
)partitioned by (
  dt string comment '分区字段，yyyyMMdd'
)stored as orc
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_device_tag_statistics';

createtab_stmt
DROP TABLE `dwh.dm_interest_tag_orc`;
CREATE EXTERNAL TABLE `dwh.dm_interest_tag_orc`(
    `device_id` string,
    `device_type` string,
    `platform` string,
    `tags` string)
PARTITIONED BY (
    `year` string,
    `month` string,
    `day` string,
    `business` string)
STORED AS ORC LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_interest_tag_orc';