#!/usr/bin/env bash



# # # # # # # # # # # # # # # # # # # # # #
# @file    :all_cross.sh
# @author  :liushuai
# @revision:2017-05-17 20:09
# @desc    ：dmp 4个数据源的交集与日活
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_GA="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/ods_ga_device_daily/${year}/${month}/${day}/"
INPUT_3S="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/tmp/3s_install_daily/${year}/${month}/${day}/"
INPUT_DSP="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_dsp_request_daily/${year}/${month}/${day}/"
INPUT_M="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_adn_sdk_request_daily/${year}/${month}/${day}/"
OUTPUT="${REQUEST_PATH}/all_cross/${year}/${month}/${day}/"

hadoop fs -rmr "${OUTPUT}"

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.SourceCrossMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INPUT_GA}" "${INPUT_3S}" "${INPUT_DSP}" "${INPUT_M}" "${OUTPUT}"