#!/bin/bash


# # # # # # # # # # # # # # # # # # # # # #
# @file    :app_url_category.sh
# @author  :liushuai
# @revision:2017-03-06 10:45
#得到各package的url与category
#
#
#
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


# 挂载hive分区
# $1 table name
# $2 partition
# $3 hdfs path
mount_partition() {
local MOUNT_PARTITION=""
hive_cmd "
use dev;
ALTER TABLE $1 ADD IF NOT EXISTS PARTITION ($2)
    LOCATION '$3';
" || exit 1
}


DSP_INPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_adn_sdk_request_daily/${year}/${month}/${day}/"
OUT_PUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/app_url_category/${year}/${month}/${day}/"
iosFile="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_app_info_ios/${year}/${month}/${day}/"
adrFile="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_app_info_adr/${year}/${month}/${day}/"



hadoop fs -rmr ${OUT_PUT}

hadoop jar ../${JAR} mobvista.prd.datasource.table.AppUrlMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -DiosFile="${iosFile}" \
    -DadrFile="${adrFile}" \
    "${DSP_INPUT}" "${OUT_PUT}"

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "app_url_category" "year='${year}', month='${month}', day='${day}'" "$OUT_PUT"