#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :merge_dmp_dsp_interest.sh
# @author  :liushuai
# @revision:2017-03-06 10:45
# @desc    :创建dsp分国家的兴趣表
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

OLD_LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
old_year=${OLD_LOG_TIME:0:4}
old_month=${OLD_LOG_TIME:4:2}
old_day=${OLD_LOG_TIME:6:2}


hive_cmd "
use dev;
drop table tmp_dmp_dsp_interest;
add file interest.py;
create table if not exists tmp_dmp_dsp_interest
as
	select distinct dsp.device_id,dsp.device_type,country,interestOne,interestTwo from
		(select device_id,device_type from
		dwh.etl_dsp_request_daily
		where date='${year}-${month}-${day}') dsp
	join
		(select device_id,id_type,country_code country from
		dwh.ods_adn_device_total
		where year='${old_year}' and
		month='${old_month}' and
		day='${old_day}') dmp
		on dsp.device_id=dmp.device_id and dsp.device_type=dmp.id_type
	JOIN
		(select transform(*)
		using 'python interest.py' as (device_id,device_type,interestOne,interestTwo)
		from dwh.dm_interest_tag
		where year='${old_year}' and
		month='${old_month}' and
		day='${old_day}' and
		business='all'
		) interest
	on dsp.device_id=interest.device_id and dsp.device_type=interest.device_type where  interestOne is not null;
"
if [ $? -ne 0 ];then
  exit 255
fi