#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :count_other_id.sh
# @author  :liushuai
# @revision:2017-05-17 20:09
# @desc    ：计算其他id（IMEI，mac，android_id）的数量
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_ids_mapping/$year/$month/$day/adn_request"
TEMP_OUT_PATH="${REQUEST_PATH}/tmp_count_other_id/$year/$month/$day/"
OUTPUT_PATH="${REQUEST_PATH}/count_other_id/$year/$month/$day/"

hadoop fs -rmr $TEMP_OUT_PATH
hadoop fs -rmr ${OUTPUT_PATH}

hadoop jar ../${JAR} mobvista.prd.datasource.countotherid.CountOtherIDMR \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  ${INPUT_PATH} $TEMP_OUT_PATH ${OUTPUT_PATH} "10,2"
if [ $? -ne 0 ];then
  exit 255
fi