#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :dsp_count_country_interest.sh
# @author  :liushuai
# @revision:2017-05-17 20:09
# @desc    ：每天的dsp用户的兴趣标签
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
LOG_TIME=$(date +%Y%m%d -d "-2 days $ScheduleTime")

date_path=${LOG_TIME:0:4}/${LOG_TIME:4:2}/${LOG_TIME:6:2}


INTEREST_INPUT_PATH="$DM_INTEREST_PATH/$date_path/all/"
DSP_INPUT_PATH="${ETL_DSP_REQ_DAILY}/$date_path/"
OUTPUT_PATH="${REQUEST_PATH}/tmp_dsp_interest/$date_path"

#检查文件是否存在
check_await "$INTEREST_INPUT_PATH/_SUCCESS"
check_await "$DSP_INPUT_PATH/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num "${INTEREST_INPUT_PATH}")

hadoop fs -rm -r $OUTPUT_PATH

hadoop jar ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.CountryInterestMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${DSP_INPUT_PATH} \
    ${INTEREST_INPUT_PATH} \
    ${OUTPUT_PATH} \
    ${REDUCE_NUM}

if [ $? -ne 0 ]; then
    exit 255
fi

