#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :count_country_dsp_m.sh
# @author  :liushuai
# @revision:2017-05-18 14:45
# @desc    ：分国家统计M系统与dsp重合量
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-6 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_PATH="${REQUEST_TMP_PATH}/dsp_m_merge_3_day/${year}/${month}/${day}/"
OUTPUT_PATH="${REQUEST_TMP_PATH}/count_dsp_m_merge_3_day/${year}/${month}/${day}/"

hadoop fs -rmr ${OUTPUT_PATH}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.CountCountryDspMMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -input ${INPUT_PATH} \
    -output ${OUTPUT_PATH} \
    -reduceNum 1

if [ $? -ne 0 ];then
  exit 255
fi