#!/usr/bin/env bash

source ../prd_env.sh
LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

now=`date -d"$ScheduleTime" +%w`

if [ $now -eq 2 ] || [ $now -eq 3 ] || [ $now -eq 5 ] || [ $now -eq 6 ] || [ $now -eq 0 ]; then
    echo "$LOG_TIME is not Monday or Thursday"
    exit 0
fi

INPUT_PATH="s3://mob-emr-test/liushuai/eggplants_count/${year}/${month}/${day}"
OUTPUT_PATH="${REQUEST_PATH}/eggplants/${year}/${month}/${day}/"
hadoop fs -text ${INPUT_PATH}/* >> eggplants
result_file="茄子分国家分app.xls"

java -cp ../${JAR} mobvista.prd.datasource.eggplants.EggplantsCountTable
if [ $? -ne 0 ];then
  exit 255
fi

hadoop fs -test -e ${OUTPUT_PATH}
if [ $? -eq 0 ];then
  hadoop fs -rm ${OUTPUT_PATH}/$result_file
else
  hadoop fs -mkdir -p ${OUTPUT_PATH}
fi

hadoop fs -put $result_file ${OUTPUT_PATH}
if [ $? -ne 0 ];then
  exit 255
fi

python2.7 ../python/sendMail.py -t 'mingyuan.ren@mobvista.com'  -c 'walt@mobvista.com,feng.liang@mobvista.com,kai.liu@mobvista.com' \
-s "茄子数据报表-$LOG_TIME" -b "hi，明远<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;茄子数据见附件<br/><br/>" -a ./${result_file}
if [ $? -ne 0 ];then
  exit 255
fi

rm eggplants $result_file

