package mobvista.dmp.datasource.apptag.crawler;

import mobvista.dmp.util.HttpUtil;

import java.io.IOException;

/**
 * Created by fl on 2017/7/12.
 */
public class BundleVisitor implements AppInfoCrawler.DetailVisitor {
    private final String lookupUrl = "http://itunes.apple.com/lookup?bundleId=%s&country=US";
    private final ProxyManager proxyManager;

    public BundleVisitor(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Override
    public HttpUtil.HttpResult visit(String packageName) throws IOException {
        if (packageName.startsWith("id")) {
            packageName = packageName.substring(2);
        }
        return HttpUtil.doGet(String.format(lookupUrl, packageName), proxyManager.getProxy());
    }
}
