package mobvista.dmp.datasource.apptag.crawler;

import mobvista.dmp.util.MRUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;

/**
 * author: houying
 * date  : 16-11-4
 * desc  :
 */
public class IosDetailParser extends AbstractDetailParser {
    private static final Logger logger = LoggerFactory.getLogger(IosDetailParser.class);
    private final ObjectMapper objectMapper;

    public IosDetailParser(String file, String date) {
        super(file, date);
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String parse(String packageName, String html) throws IOException {
        JsonNode node = objectMapper.readTree(html);
        int resultCount = node.get("resultCount").asInt();
        if (resultCount == 0) {
            notFound++;
            //logger.info("[resultCount = 0 for package name={} in itunes store]", packageName);
            return null;
        }
        node = node.get("results");
        if (node.size() > 0) {
            node = node.get(0);
            String languageCodesISO2A = node.has("languageCodesISO2A")? node.get("languageCodesISO2A").toString(): "[]";
            String fileSizeBytes = node.has("fileSizeBytes") ? node.get("fileSizeBytes").asText(): "";
            long id = node.get("trackId").asLong();
            String name = node.get("trackName").asText();
            String bundleId = node.get("bundleId").asText();
            String releaseDate = node.get("releaseDate").asText();
            String categoryIdList = node.get("genreIds").toString();
            String categoryList = node.get("genres").toString();
            String primaryGenreName = node.get("primaryGenreName").asText();
            String primaryGenreId = node.get("primaryGenreId").asText();
            String trackViewUrl = node.get("trackViewUrl").asText();
            int userRatingCount = node.has("userRatingCount") ? node.get("userRatingCount").asInt():0; //用户评分总数
            long artistId = node.get("artistId").asLong();
            String artistName = node.get("artistName").asText();
            String sellerName = node.get("sellerName").asText();
            boolean isGameCenterEnabledBoolean = node.get("isGameCenterEnabled").asBoolean();
            int isGameCenterEnabled = isGameCenterEnabledBoolean ? 1 : 0;
            String contentAdvisoryRating = node.get("contentAdvisoryRating").asText();
            String advisories = node.get("advisories").toString();
            return MRUtils.JOINER.join(
                    id,
                    name,
                    fileSizeBytes,
                    languageCodesISO2A,
                    bundleId,
                    releaseDate,
                    primaryGenreName,
                    primaryGenreId,
                    categoryList,
                    categoryIdList,
                    userRatingCount,
                    trackViewUrl,
                    date,
                    artistId,
                    artistName,
                    sellerName,
                    isGameCenterEnabled,
                    contentAdvisoryRating,
                    advisories
            );
        }
        return null;
    }
}
