package mobvista.dmp.datasource.eggplants;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import mobvista.dmp.util.MRUtils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.*;

/**
 * author: houying
 * date  : 17-3-15
 * desc  :
 */
public class HttpCatchEggplants {

    private String packageList;
    private String input;
    private String output;

    public void init(String input, String output, String pkgFile) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(pkgFile), Charsets.UTF_8);
        this.packageList = MRUtils.join(lines, ",");
        this.input = input;
        this.output = output;
    }

    public void run() throws IOException, InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        final List<CatchThread> threads = Lists.newArrayList();
        BlockingQueue<String> outputQueue = new ArrayBlockingQueue<>(20);
        WriteFileThread writeFileThread = new WriteFileThread(output, outputQueue);
        //写线程
        Thread thread = new Thread(writeFileThread);
        thread.start();
        //抓取线程
        for (int i = 0;i < 10; i++) {
            CatchThread r = new CatchThread(outputQueue, packageList);
            threads.add(r);
            pool.execute(r);
        }

        CharStreams.readLines(new BufferedReader(new FileReader(input)), new LineProcessor<Void>() {
            int lineNum = 0;
            int i = 0;
            @Override
            public boolean processLine(String line) throws IOException {
                CatchThread r = threads.get(i);
                try {
                    r.push(line);
                } catch (InterruptedException e) {
                    return false;
                }
                i = (i + 1) % 10;
                lineNum++;
                if (lineNum % 1000 == 0) {
                    System.out.println("handled: " + lineNum);
                }
                return true;
            }

            @Override
            public Void getResult() {
                System.out.println("line num: " + lineNum);
                return null;
            }
        });

        for (CatchThread catchThread: threads) {
            catchThread.stop();
        }
        while (((ThreadPoolExecutor) pool).getActiveCount() != 0) {
            pool.awaitTermination(1, TimeUnit.SECONDS);
        }
        pool.shutdown();
        writeFileThread.stop();
        thread.join();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length != 3) {
            System.out.println("缺少参数");
            System.exit(1);
        }
        HttpCatchEggplants h = new HttpCatchEggplants();
        h.init(args[0], args[1], args[2]);
        h.run();
    }
}
