package mobvista.dmp.datasource.packagelist.mapreduce;

/**
 *
 */
public class JsonVO implements Comparable<JsonVO> {
    private String package_name;
    private String date;

    public JsonVO(String package_name, String date) {
        this.package_name = package_name;
        this.date = date;
    }

    @Override
    public int compareTo(JsonVO o) {
        if (this.package_name.equals(o.getPackage_name())) {
            return o.getDate().compareTo(this.date);
        }
        return this.package_name.compareTo(o.getPackage_name());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JsonVO) {
            JsonVO vo = (JsonVO) obj;
            if (this.package_name.equals(vo.getPackage_name())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.package_name.hashCode();
    }

    public String getPackage_name() {
        return package_name;
    }

    public void setPackage_name(String package_name) {
        this.package_name = package_name;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }
}
