package mobvista.dmp.datasource.taobao;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class UCActivitionHttpPostRequest {


    public static void main(String[] args) {
        String url = "https://pre-ugp.uc.cn/crowd/batch/v2";
        JSONObject postJSONobject = new JSONObject();

        List<String> uidsList = Arrays.asList("00200072f915c1ca9dee20cedeb275a5", "00019c55395e6f73ccae5b5ef3aec28c", "0015685ac69cd22edf8e8ebe1e9cd71f", "00156dcfe3263865123d0aace1643688","002b3c08245db0c7c70742c4480d3d72");
        List<String> crowdCodesList = Arrays.asList("232ed75ec2167b5e1f7815284ea8f79b", "45aa669dda34d2839dfe4943ed72998f");
        postJSONobject.put("uids", uidsList);
        postJSONobject.put("uidType", "IMEI_MD5");
        postJSONobject.put("crowdCodes", crowdCodesList);
        postJSONobject.put("product", "UC");
        postJSONobject.put("channel", "mindx");

        System.out.println(post(postJSONobject, url));
    }


    public static String PostJSON( List<String> uidsList,String uidType) {

        String url = "https://ugp.uc.cn/crowd/batch/v2";
        JSONObject json = new JSONObject();

//        List<String> uidsList = Arrays.asList("00200072f915c1ca9dee20cedeb275a5", "00019c55395e6f73ccae5b5ef3aec28c", "0015685ac69cd22edf8e8ebe1e9cd71f", "00156dcfe3263865123d0aace1643688","002b3c08245db0c7c70742c4480d3d72");
//        List<String> uidsList = Arrays.asList("00200072f915c1ca9dee20cedeb275a5", "00019c55395e6f73ccae5b5ef3aec28c", "0015685ac69cd22edf8e8ebe1e9cd71f", "00156dcfe3263865123d0aace1643688","002b3c08245db0c7c70742c4480d3d72");
        List<String> crowdCodesList = Arrays.asList("d3f521a0253bc032f245530c18e47348","4b5a58c23b3bd5e171be0cc430593086","33c7777291f475dd2e3d15872a3b9c76","304fcdfc329107ce4817e0606dc4bc80","4e7bfc1c7924e47fc05767208dbbfdeb","223a2a9d2af12c8b744ef91a84fd9ab9","bf7722f389f6ff1c7a5769f7998caabc");
        json.put("uids", uidsList);
        json.put("uidType", uidType);
        json.put("crowdCodes", crowdCodesList);
        json.put("product", "UC");
        json.put("channel", "Mintegral");

        HttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/json");
//        post.addHeader("Authorization", "Basic YWRtaW46");
        String result = "";
        try {
            StringEntity s = new StringEntity(json.toString(), "utf-8");
            s.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
                    "application/json"));
            post.setEntity(s);
            // 发送请求
            HttpResponse httpResponse = client.execute(post);
            // 获取响应输入流
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null)
                strber.append(line + "\n");
            inStream.close();
            result = strber.toString();
            System.out.println(result);
//            if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
//                System.out.println("请求服务器成功，做相应处理");
//            } else {
//                System.out.println("请求服务端失败");
//            }
        } catch (Exception e) {
//            System.out.println("请求异常");
//            throw new RuntimeException(e);

        }
        return result;
    }

    public static String post(JSONObject json, String URL) {

        HttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(URL);
        post.setHeader("Content-Type", "application/json");
        post.addHeader("Authorization", "Basic YWRtaW46");
        String result = "";

        try {
            StringEntity s = new StringEntity(json.toString(), "utf-8");
            s.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
                    "application/json"));
            post.setEntity(s);

            // 发送请求
            HttpResponse httpResponse = client.execute(post);

            // 获取响应输入流
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null)
                strber.append(line + "\n");
            inStream.close();
            result = strber.toString();
            System.out.println(result);
            if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                System.out.println("请求服务器成功，做相应处理");
            } else {
                System.out.println("请求服务端失败");
            }
        } catch (Exception e) {
            System.out.println("请求异常");
            throw new RuntimeException(e);
        }

        return result;
    }

}
