package mobvista.dmp.datasource.toutiao.dmp;

import mobvista.dmp.datasource.toutiao.dmp.DmpDataProto.IdItem.DataType;
import java.io.*;
import java.util.Base64;
import java.util.Date;

public class TouTiaoUtil {

    public static void main(String[] args) {
        String inputFileName = args[0];
        String outputFileName = args[1];
        String device_id = args[2];
        String line = "";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFileName));
            BufferedReader in = new BufferedReader(new FileReader(inputFileName));
            line = in.readLine();
            while (line != null) {
                String protocolBufferBase64String = getProtocolBufferBase64String(line, device_id);
                out.write(protocolBufferBase64String + "\n");
                line = in.readLine();
            }
            in.close();
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getProtocolBufferBase64String(String device_id,String device_type){
        DmpDataProto.DmpData.Builder dmpDataBuilder = DmpDataProto.DmpData.newBuilder();
        DmpDataProto.IdItem.Builder idListBuilder = dmpDataBuilder.addIdListBuilder();
        idListBuilder.setId(device_id);
        long time = new Date().getTime();
        idListBuilder.setTimestamp((int)(time/1000));
        idListBuilder.setDataType(getDataType(device_type));
        idListBuilder.addTags("未知");

        DmpDataProto.DmpData build = dmpDataBuilder.build();
        byte[] bytes = build.toByteArray();

        Base64.Encoder encoder = Base64.getEncoder();
        String result = encoder.encodeToString(bytes);
        return result;
    }

    public static DataType getDataType(String device_type){
        DmpDataProto.IdItem.DataType dataType = DmpDataProto.IdItem.DataType.IDFA;
        device_type=device_type.toUpperCase();
        switch(device_type){
            case "IMEI":
                dataType = DmpDataProto.IdItem.DataType.IMEI;
                break;
            case "IDFA":
                dataType = DmpDataProto.IdItem.DataType.IDFA;
                break;
            case "UID":
                dataType = DmpDataProto.IdItem.DataType.UID;
                break;
            case "IMEIMD5":
                dataType = DmpDataProto.IdItem.DataType.IMEI_MD5;
                break;
            case "IDFAMD5":
                dataType = DmpDataProto.IdItem.DataType.IDFA_MD5;
                break;
            case "MOBILE_HASH_SHA256":
                dataType = DmpDataProto.IdItem.DataType.MOBILE_HASH_SHA256;
                break;
            case "OAID":
                dataType = DmpDataProto.IdItem.DataType.OAID;
                break;
            case "OAIDMD5":
                dataType = DmpDataProto.IdItem.DataType.OAID_MD5;
                break;
        }
        return dataType;
    }
}
