package mobvista.prd.datasource.country.interest.mapreduce;

import com.google.common.collect.Lists;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/**
 * Created by Administrator on 2017/5/19 0019.
 */
public class CreateCountryInterestTable {
    public static void main(String[] args) throws IOException {
        List<String> list = readCountry(args[0]);
        FileOutputStream fos = new FileOutputStream(args[1]);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        List<String> head = Lists.newArrayList();//表头
        head.add("Country");
        head.add("Interest Tag 1");
        head.add("Interest Tag 2");
        head.add("Device Count");
        int columnHead = 0;
        HSSFRow rowOne = s.createRow(0);
        for (String column : head) {
            HSSFCell cell = rowOne.createCell(columnHead, 0);
            HSSFRichTextString hts = new HSSFRichTextString(column);
            cell.setCellValue(hts);
            columnHead++;
        }
        int row = 1;
        for (String column : list) {
            columnHead = 0;
            rowOne = s.createRow(row);
            String[] fields = column.split("\t", -1);
            int num = 0;
            for (String field : fields) {
                HSSFCell cell = rowOne.createCell(columnHead, 0);
                if (num == 0) {
                    String country = field.split(":",-1)[0];
                    cell = rowOne.createCell(columnHead, 0);
                    HSSFRichTextString hts = new HSSFRichTextString(country);
                    cell.setCellValue(hts);
                    columnHead++;
                    String interestOne = field.split(":",-1)[1];
                    cell = rowOne.createCell(columnHead, 0);
                    hts = new HSSFRichTextString(interestOne);
                    cell.setCellValue(hts);
                    columnHead++;
                    if (field.split(":",-1).length == 3) {
                        String interestTwo = field.split(":",-1)[2];
                        cell = rowOne.createCell(columnHead, 0);
                        hts = new HSSFRichTextString(interestTwo);
                        cell.setCellValue(hts);
                        columnHead++;
                    } else {
                        columnHead++;
                    }
                    num++;
                    continue;
                }
                HSSFRichTextString hts = new HSSFRichTextString(field);
                cell.setCellValue(hts);
                columnHead++;
            }
            row++;
        }
        wb.write(fos);
        fos.flush();
        fos.close();
    }

    public static List<String> readCountry(String file) throws IOException {
        List<String> list = Lists.newArrayList();
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            String[] fields = s.split("\t", -1);
            String one;
            if (fields[2] == null || fields[2].equals("NULL") || fields[2].equals("")) {
                one = fields[0] + ":" + fields[1];
            } else {
                one = fields[0] + ":" + fields[1] + ":" + fields[2];
            }
            list.add(one + "\t" + fields[3]);
            s = br.readLine();
        }
        br.close();
        fr.close();
        return list;
    }
}
