package mobvista.dmp.common

import mobvista.dmp.util.MRUtils
import org.apache.commons.lang3.StringUtils
import org.apache.spark.sql.Row

/**
 * @package: mobvista.dmp.common
 * @author: wangjf
 * @date: 2020/4/1
 * @time: 2:49 下午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
class CustomInteratorAll(iter: Iterator[Row]) extends Iterator[(String, String)] {
  def hasNext: Boolean = {
    iter.hasNext
  }

  def next: (String, String) = {
    val row = iter.next
    val device_id = row.getAs("device_id").toString
    val device_type = row.getAs("device_type").toString
    val platform = row.getAs("platform").toString
    val country = if (row.getAs("country") != null && StringUtils.isNotBlank(row.getAs[String]("country"))
      && row.getAs[String]("country").toUpperCase.matches(MobvistaConstant.countryPtn)) {
      row.getAs("country").toString.toUpperCase
    } else {
      ""
    }
    val install_list = row.getAs("install_list").toString
    val ext_data = row.getAs("ext_data").toString
    val update_date = row.getAs("update_date").toString
    //  new table
    (MRUtils.JOINER.join(device_id, device_type, platform), MRUtils.JOINER.join(install_list, ext_data, update_date, country))
  }
}