package mobvista.dmp.datasource.bytedance

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

import scala.collection.mutable.ArrayBuffer

/**
  * @package: mobvista.dmp.datasource.bytedance
  * @author: wangjf
  * @time: 2019-02-27 18:24:49
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class ByteDanceInstallList extends CommonInstallList {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  override def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val apps = array(3).split("#")
    apps.foreach(r => {
      buffer += Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", new InstallInfo(r, date))
    })
    buffer.toArray
  }
}

object ByteDanceInstallList {
  def main(args: Array[String]): Unit = {
    new ByteDanceInstallList().run(args)
  }
}