package mobvista.dmp.datasource.taobao

object Constant {
  val uc_lahuo_sql: String =
    s"""
       |SELECT device_ids FROM dmp.uc_lahuo_result_daily_all WHERE dt = '@date' AND device_type='@device_type'
    """.stripMargin

  val alipay_lahuo_sql: String =
    s"""
       |SELECT device_ids FROM dmp.alipay_lahuo_result_daily_all WHERE dt >= '@begin_date' AND dt <= '@end_date' AND device_type='@device_type' AND hour='@hour'
    """.stripMargin

  val youku_laxin_sql: String =
    s"""
       |SELECT device_ids FROM dmp.youku_laxin_result_daily_all WHERE dt >= '@begin_date' AND dt <= '@end_date' AND device_type='@device_type'
    """.stripMargin


  def buildPartUCLaHuo(partSize: Int): Seq[String] = {
    var list: scala.List[String] = scala.List()
    for (i <- 0 until partSize) {
      list = list.::(s"CRC32(device_ids) % $partSize = $i")
    }
    list = list.reverse
    list
  }
}
