package mobvista.dmp.datasource.taobao

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.sql.{SaveMode, SparkSession}

import java.net.URI

/**
 * @author jiangfan
 * @date 2021/4/23 10:42
 */
class EtlComTencentNewsDaily extends CommonSparkJob with Serializable  {
  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("dt_today", true, "[must] dt_today")
    options.addOption("dt_dash_rec7day", true, "[must] dt_dash_rec7day")
    options.addOption("dt_dash_rec15day", true, "[must] dt_dash_rec15day")
    options.addOption("output",true, "[must] output")
    options.addOption("coalesce",true, "[must] coalesce")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val dt_today = commandLine.getOptionValue("dt_today")
    val dt_dash_rec7day = commandLine.getOptionValue("dt_dash_rec7day")
    val dt_dash_rec15day = commandLine.getOptionValue("dt_dash_rec15day")
    val output = commandLine.getOptionValue("output")
    val coalesce = commandLine.getOptionValue("coalesce")


    val spark = SparkSession.builder()
      .appName("EtlComTencentNewsDaily")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()

    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output), true)

    val sc = spark.sparkContext
    try {
      val sql1 =
        s"""
           |select device_id,device_type,platform,'com.tencent.news_bes_7' package_name from dwh.dm_install_list_v2
           |where dt='${dt_today}' and business='dsp_req'  and  update_date>='${dt_dash_rec7day}'
           |and package_name in ('com.tencent.news_bes')
           |union
           |select device_id,device_type,platform,'com.tencent.news_bes_15' package_name from dwh.dm_install_list_v2
           |where dt='${dt_today}' and business='dsp_req'  and  update_date>='${dt_dash_rec15day}'
           |and package_name in ('com.tencent.news_bes')
           |union
           |select device_id,device_type,platform,'com.tencent.news_oppo_7' package_name from dwh.dm_install_list_v2
           |where dt='${dt_today}' and business='dsp_req'  and  update_date>='${dt_dash_rec7day}'
           |and package_name in ('com.tencent.news_oppo')
           |union
           |select device_id,device_type,platform,'com.tencent.news_oppo_15' package_name from dwh.dm_install_list_v2
           |where dt='${dt_today}' and business='dsp_req'  and  update_date>='${dt_dash_rec15day}'
           |and package_name in ('com.tencent.news_oppo')
        """.stripMargin

      spark.sql(sql1).coalesce(coalesce.toInt)
        .write
        .mode(SaveMode.Overwrite)
        .option("orc.compress", "zlib")
        .option("mapreduce.fileoutputcommitter.marksuccessfuljobs", false)
        .orc(output)

    } finally {
      spark.stop()
    }
    0
  }
}


object EtlComTencentNewsDaily {
  def main(args: Array[String]): Unit = {
   new EtlComTencentNewsDaily().run(args)
  }
}
